/***********************************************************************/
/*                                                                     */
/* ADMImageOld.h                                                       */
/* Old versions of ADM Image suite                                     */
/*                                                                     */
/* Copyright 1996-1999 Adobe Systems Incorporated.                     */
/* All Rights Reserved.                                                */
/*                                                                     */
/* Patents Pending                                                     */
/*                                                                     */
/* NOTICE: All information contained herein is the property of Adobe   */
/* Systems Incorporated. Many of the intellectual and technical        */
/* concepts contained herein are proprietary to Adobe, are protected   */
/* as trade secrets, and are made available only to Adobe licensees    */
/* for their internal use. Any reproduction or dissemination of this   */
/* software is strictly forbidden unless prior written permission is   */
/* obtained from Adobe.                                                */
/*                                                                     */
/***********************************************************************/

#ifndef __ADMImageOld__
#define __ADMImageOld__

#ifndef __ADMTypes__
#include "ADMTypes.h"
#endif


// -----------------------------------------------------------------------------

#ifdef __cplusplus
extern "C" {
#endif

#pragma PRAGMA_ALIGN_BEGIN
#pragma PRAGMA_IMPORT_BEGIN


// =============================================================================
//		* ADM Image Suite, version 1
// =============================================================================

#define kADMImageSuiteVersion1 1
#define kADMImageSuiteVersion kADMImageSuiteVersion1	// not current, just frozen

// -----------------------------------------------------------------------------

typedef struct ADMImageSuite1
{
	ADMImageRef ASAPI (*Create)(ASInt32 inWidth, ASInt32 inHeight);
	void ASAPI (*Destroy)(ADMImageRef inImage);

	ASInt32 ASAPI (*GetWidth)(ADMImageRef inImage);
	ASInt32 ASAPI (*GetHeight)(ADMImageRef inImage);
	ASInt32 ASAPI (*GetByteWidth)(ADMImageRef inImage);
	ASInt32 ASAPI (*GetBitsPerPixel)(ADMImageRef inImage);
	
	ASBytePtr ASAPI (*BeginBaseAddressAccess)(ADMImageRef inImage);
	void ASAPI (*EndBaseAddressAccess)(ADMImageRef inImage);
	
	ADMDrawerRef ASAPI (*BeginADMDrawer)(ADMImageRef inImage);
	void ASAPI (*EndADMDrawer)(ADMImageRef inImage);
	
	void ASAPI (*BeginAGMImageAccess)(ADMImageRef inImage, struct _t_ADMAGMImageRecord* inImageRecord);
	void ASAPI (*EndAGMImageAccess)(ADMImageRef inImage);
	
	ASErr ASAPI (*GetPixel)(ADMImageRef inImage, const ASPoint* inPoint, ASRGBColor* outColor);
	ASErr ASAPI (*SetPixel)(ADMImageRef inImage, const ASPoint* inPoint, const ASRGBColor* inColor);
	
	ADMImageRef ASAPI (*CreateBitmap)(ASInt32 inWidth, ASInt32 inHeight);
	ADMImageRef ASAPI (*CreateOffscreen)(ASInt32 inWidth, ASInt32 inHeight);

}
ADMImageSuite1;

typedef ADMImageSuite1 ADMImageSuite;	// for historical reasons


// -----------------------------------------------------------------------------

#pragma PRAGMA_IMPORT_END
#pragma PRAGMA_ALIGN_END

#ifdef __cplusplus
}
#endif

#endif
